% ------------------------------------------------------------------------
% Script: infile_1d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 1D P-N model
% ------------------------------------------------------------------------

    % % System name
 
    system='1D P-N model';
 
    % % The absolute path to save the result files
 
    filepath=pwd;
 
    % % The dimension of P-N model: 1 or 2
 
    misdim=1;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
    
    % % The data of GSFE (unit: J/m2) and normalized disregistry vector (unit:1)
    
    Ux=[0
0.03485
0.0721
0.10256
0.11636
0.13433
0.15383
0.17311
0.19809
0.22702
0.26295
0.31971
0.36265
0.39859
0.44964
0.49807
0.56183
0.60609
0.6337
0.66832
0.70974
0.7402
0.78862
0.81338
0.84121
0.85633
0.87298
0.88679
0.90607
0.92404
0.94069
0.96151
1];
    SFE=[0
0.04365
0.25649
0.48787
0.62905
0.78837
0.94009
1.09434
1.2486
1.37377
1.42435
1.31772
1.16599
1.0307
0.88952
0.83894
0.90806
1.03323
1.14239
1.27009
1.39484
1.42688
1.32825
1.20856
1.01722
0.88404
0.75128
0.61009
0.4453
0.30158
0.17936
0.06767
0];
    
    % % Which trial function of disregistry vector to employ (>=1)
    
    Nmis=12;
       
    % % Considering the first-order approximation in the trial function of disregistry
    %   vector (1) or NOT (0)
    
    mis_1st=0;
    
    % % The value of Burgers Vector (unit: A)
 
    BurVect=5.75;
    
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=117;
    poisson_ratio=0.2403;
    
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='e';
    
    % % Which GSFE fitting function to employ (>=0)
    
    fitcut=6;
    
    % % Matrix of the lower and upper bounds, and initial values of each unknown 
    %   variable ([Lower bound, Upper bound, StartPoint]) 
    
    Xcoef_range=[  0.0000,  0.3000,  0.1667];
    Xdist_range=[-20.0000, 20.0000, 10.0000];
    Xwid_range =[  0.0000,  4.0000,  0.5000];
    Xalpha_range=[ 0.0000,  2.00000, 1.0000];
    
    % % The mothed for fitting the restoring force: "1d_fitting_toolbox" or "1d_lsq_curvefit"
    
    fitmethod='1d_lsq_curvefit';
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
 
    % % Interplanar distance ?x (unit: A) 

    Inpas=5.75;
    % Inpas=BurVect;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
